#version 120

//#define ATTENUATION

// It was expressed that some drivers required this next line to function properly
precision highp float;
#define MAX_LIGHTS 8

#define NUMLIGHTS 2
#define NUMLIGHTSINTEXTURE 2

#define TEXTURESIZE 1024.0f
#define SHADOW 0.3f

//shadow casting spot lights

//const int method = 0;
uniform int method;
// 0 sharp
// 1 smooth
// 2 smooth with linear interpolation

in vec3 alightVec[MAX_LIGHTS];
in vec3 aeyeVec[MAX_LIGHTS];
in vec2 texCoord;

in vec4 vpos; //vertex pos
uniform int renderingmirror;
uniform vec4 clipeq;

in float ShadowAngle[NUMLIGHTS];
in vec4 ShadowCoord[NUMLIGHTS];
uniform float anglebias;

uniform vec4 LightsPos[NUMLIGHTS];
uniform vec4 Lights[NUMLIGHTS];
in vec4 vN_;

uniform vec4 glColor;

uniform float bias;
uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];
uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D lightMap;

//uniform sampler2D specularMap;
uniform sampler2D shadowMap;
//uniform float invRadius;
//out vec4 gl_FragColor;
/*
float texture2DShadowLerp(sampler2D depths, vec2 size, vec2 uv, float compare){
    vec2 texelSize = vec2(1.0)/size;
    vec2 f = fract(uv*size+0.5);
    vec2 centroidUV = floor(uv*size+0.5)/size;

    float lb = texture2DCompare(depths, centroidUV+texelSize*vec2(0.0, 0.0), compare);
    float lt = texture2DCompare(depths, centroidUV+texelSize*vec2(0.0, 1.0), compare);
    float rb = texture2DCompare(depths, centroidUV+texelSize*vec2(1.0, 0.0), compare);
    float rt = texture2DCompare(depths, centroidUV+texelSize*vec2(1.0, 1.0), compare);
    float a = mix(lb, lt, f.y);
    float b = mix(rb, rt, f.y);
    float c = mix(a, b, f.x);
    return c;
}
*/

void main (void)
{

    vec3 lightVec;
    vec3 eyeVec;
    vec4 accvDiffuse = vec4(0.0);
    vec4 accvSpecular = vec4(0.0);
    float distSqr;
    vec3 lVec;
    vec3 vVec;
    float att;
    vec4 base;
    vec4 vAmbient;
    vec3 bump;
    float diffuse;
    vec4 vDiffuse;
    vec4 vSpecular;
    float specular;
    vec3 nrmltexture;

    // if (vpos.y<0.0f) discard;
//    if (renderingmirror>0 && dot(gl_ClipPlane[0], vpos) > 0) {
    if (renderingmirror>0 && dot(clipeq, vpos) < 0)
    {
        discard;
    }
    base = texture2D(colorMap, texCoord);
    vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
    for (int i=0; i<MAX_LIGHTS; i++)
    {
        if (lightsEnabled[i]>0.0)
        {
            lightVec=alightVec[i];
            eyeVec=aeyeVec[i];
            distSqr = dot(lightVec, lightVec);
            att = clamp(1.0 - lightsinvRadius[i] * sqrt(distSqr), 0.0, 1.0);
            lVec = lightVec * inversesqrt(distSqr);
            vVec = normalize(eyeVec);

            //nrmltexture= texture2D(normalMap, texCoord).xyz;
            //nrmltexture.z=nrmltexture.z*-1.0f;
            //bump = normalize(nrmltexture * 2.0f - 1.0);
            bump = normalize( texture2D(normalMap, texCoord).xyz * 2.0f - 1.0);
            //bump = vec3(0.0,0.0,1.0);

            //diffuse = max( dot(lVec, bump), 0.0 );
            diffuse = clamp( dot(lVec, bump), 0.0, 1.0 );
//	vDiffuse = gl_LightSource[i].diffuse * gl_FrontMaterial.diffuse * diffuse *
            vDiffuse = gl_LightSource[i].diffuse * diffuse *
                       texture2D(lightMap, vec2(diffuse-0.01,lightMapSelect[i]/2.0f+0.5f));
            accvDiffuse = accvDiffuse + vDiffuse;

            //specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0),
            //gl_FrontMaterial.shininess );

            //specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess ) * texture2D(specularMap, texCoord).r;
            //specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), 24.0f ) * 1.0f;//texture2D(specularMap, texCoord).r; //here shiness is replaced with 1.0, should introduce material functionality in obj loader //16.0
            specular = pow(diffuse,48.0f);

            //vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;
//	vSpecular = gl_LightSource[i].specular * gl_FrontMaterial.specular * specular *
            vSpecular = gl_LightSource[i].specular * specular * texture2D(lightMap, vec2(specular-0.01,lightMapSelect[i]/2.0f+0.5f));
            accvSpecular = accvSpecular + vSpecular;
        }
    }
    //gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular) * att;
    //gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular);

//float bias = 0.005;
//float bias = 0.005;
//float biasx=bias;
    float totalvisibility=1.0f;
    totalvisibility=0.0f;
    vec4 v1;
    vec2 shadowcoordbig;
    vec4 projectorColor=vec4(0.0f,0.0f,0.0f,1.0f);
//vec4 totalprojectorColor=vec4(1.0f,1.0f,1.0f,1.0f);
    vec4 totalprojectorColor=vec4(0.0f,0.0f,0.0f,1.0f);
    /*
    float r1=1.0f;
    float g1=1.0f;
    float b1=1.0f;
    */
    float depth;
    float ShadowAngle2;
    for (int i=0; i<NUMLIGHTS; i++)
    {
//for (int i=0;i<1;i++){


        float biasx=bias;
        float visibility = 1.0f;
        visibility = 0.0f;
//ShadowAngle2=1.0f-clamp(ShadowAngle[i],0.0f,1.0f);
        ShadowAngle2=ShadowAngle[i];
//if (ShadowAngle<0.25f||ShadowAngle>0.75f) visibility=0.5f+ShadowAngle; else
//if ( texture2D( shadowMap, ShadowCoord.xy ).z  <  ShadowCoord.z-biasx){ //.x should be .z but since we also do coloring in pass1, we can get away with it
        vec4 ShadowCoord2=ShadowCoord[i];
//ShadowCoord2.x-=50.0f;

//if ( texture2D( shadowMap, (ShadowCoord2.xy/ShadowCoord2.w) ).z  <  1.0f-(ShadowCoord2.z/200.0f-0.5f)/ShadowCoord2.w ){


        float x=0.5f-ShadowCoord2.x/ShadowCoord2.w;
        float y=0.5f-ShadowCoord2.y/ShadowCoord2.w;

        bool inshadow=false;
        if (sqrt(x*x+y*y)>0.5f)
            inshadow=true;// else
        if (ShadowAngle2>0.2f)
            inshadow=true; //else
        {
            float ShadowAngle3 = dot(normalize(Lights[i].xyz),normalize(vec3(vpos.xyz-LightsPos[i].xzy)));
            if (ShadowAngle3<0.0f)
                inshadow=true;
        }


//ShadowAngle2 = dot(normalize(vN_.xyz),normalize(vec3(vpos.xyz-LightsPos[i].xzy)));
//ShadowAngle2 = dot(normalize(vN_.xyz),normalize(vec3(vpos.xyz-LightsPos[i].xzy)));
//if ((ShadowAngle2)>anglebias) inshadow=true;
//if ((ShadowAngle2)>anglebias) inshadow=true;
//>0.0f
//0.2
//0.1
//0.005

        float smoothsize;
        if (method==0)
            smoothsize=1.0f;
        else
            smoothsize=8.0f; //6.0f 10.0f
        float visibility4=0.0f;

        if (inshadow)
        {
            visibility=SHADOW;
            projectorColor=vec4(0.0f,0.0f,0.0f,0.0f);
        }
        else
        {
            for (float ys=0.0f; ys<smoothsize; ys++)
                for (float xs=0.0f; xs<smoothsize; xs++)
                {

                    shadowcoordbig.x=ShadowCoord2.x/ShadowCoord2.w+xs/TEXTURESIZE;
                    shadowcoordbig.y=(1.0f/NUMLIGHTSINTEXTURE)*i+ShadowCoord2.y/NUMLIGHTSINTEXTURE/ShadowCoord2.w+ys/TEXTURESIZE/NUMLIGHTSINTEXTURE;
                    float shadowcoordbig_y=ShadowCoord2.y/ShadowCoord2.w+ys/TEXTURESIZE;

                    float rdepth=texture2D(shadowMap, shadowcoordbig).r;
                    float gdepth=texture2D(shadowMap, shadowcoordbig).g;
                    float bdepth=texture2D(shadowMap, shadowcoordbig).b;
                    depth=(rdepth*256.0f*256.0f+gdepth*256.0f+bdepth)/65536.0f;

#ifdef ATTENUATION
                    float attenuation=-depth+(ShadowCoord2.z/200.0f-biasx);
#endif

                    if (method==2)
                    {
                        vec3 shadowcoordbigUL;
                        vec3 shadowcoordbigUR;
                        vec3 shadowcoordbigDL;
                        vec3 shadowcoordbigDR;

                        shadowcoordbigUL.x=shadowcoordbigDL.x=shadowcoordbig.x;
                        shadowcoordbigUR.x=shadowcoordbigDR.x=shadowcoordbig.x+1.0f/TEXTURESIZE;

                        shadowcoordbigUL.y=shadowcoordbigUR.y=shadowcoordbig.y+1.0f/TEXTURESIZE/NUMLIGHTSINTEXTURE;
                        shadowcoordbigDL.y=shadowcoordbigDR.y=shadowcoordbig.y;
                        shadowcoordbigUL.z=shadowcoordbigUR.z=shadowcoordbig_y+1.0f/TEXTURESIZE;
                        shadowcoordbigDL.z=shadowcoordbigDR.z=shadowcoordbig_y;


                        /*
                        shadowcoordbigU.x=shadowcoordbigD.x=shadowcoordbig.x;
                        shadowcoordbigU.y=shadowcoordbig.y-1.0f/TEXTURESIZE/NUMLIGHTSINTEXTURE;
                        shadowcoordbigD.y=shadowcoordbig.y+1.0f/TEXTURESIZE/NUMLIGHTSINTEXTURE;
                        shadowcoordbigU.z=shadowcoordbig_y-1.0f/TEXTURESIZE;
                        shadowcoordbigD.z=shadowcoordbig_y+1.0f/TEXTURESIZE;

                        shadowcoordbigL.y=shadowcoordbigR.y=shadowcoordbig.y;
                        shadowcoordbigL.z=shadowcoordbigR.z=shadowcoordbig_y;
                        shadowcoordbigL.x=shadowcoordbig.x-1.0f/TEXTURESIZE;
                        shadowcoordbigR.x=shadowcoordbig.x+1.0f/TEXTURESIZE;
                        */

                        rdepth=texture2D(shadowMap, vec2(shadowcoordbigUL.xy)).r;
                        gdepth=texture2D(shadowMap, vec2(shadowcoordbigUL.xy)).g;
                        bdepth=texture2D(shadowMap, vec2(shadowcoordbigUL.xy)).b;
                        float depthUL=(rdepth*256.0f*256.0f+gdepth*256.0f+bdepth)/65536.0f;
                        rdepth=texture2D(shadowMap, vec2(shadowcoordbigUR.xy)).r;
                        gdepth=texture2D(shadowMap, vec2(shadowcoordbigUR.xy)).g;
                        bdepth=texture2D(shadowMap, vec2(shadowcoordbigUR.xy)).b;
                        float depthUR=(rdepth*256.0f*256.0f+gdepth*256.0f+bdepth)/65536.0f;
                        rdepth=texture2D(shadowMap, vec2(shadowcoordbigDL.xy)).r;
                        gdepth=texture2D(shadowMap, vec2(shadowcoordbigDL.xy)).g;
                        bdepth=texture2D(shadowMap, vec2(shadowcoordbigDL.xy)).b;
                        float depthDL=(rdepth*256.0f*256.0f+gdepth*256.0f+bdepth)/65536.0f;
                        rdepth=texture2D(shadowMap, vec2(shadowcoordbigDR.xy)).r;
                        gdepth=texture2D(shadowMap, vec2(shadowcoordbigDR.xy)).g;
                        bdepth=texture2D(shadowMap, vec2(shadowcoordbigDR.xy)).b;
                        float depthDR=(rdepth*256.0f*256.0f+gdepth*256.0f+bdepth)/65536.0f;

                        visibility4=0.0f;
                        float sc2=(ShadowCoord2.z/200.0f-biasx);
                        //float lcoeff=shadowcoordbigL.x-floor(shadowcoordbigL.x*TEXTURESIZE)/TEXTURESIZE;
                        /*
                        float ulcoeff=abs(shadowcoordbigUR.x-floor(shadowcoordbig.x*TEXTURESIZE)/TEXTURESIZE)*TEXTURESIZE;
                        float urcoeff=abs(shadowcoordbigUL.x-floor(shadowcoordbig.x*TEXTURESIZE)/TEXTURESIZE)*TEXTURESIZE;
                        //float lcoeff=1.0f-rcoeff;
                        float drcoeff=abs(shadowcoordbigDL.z-floor(shadowcoordbig_y*TEXTURESIZE)/TEXTURESIZE)*TEXTURESIZE;
                        float dlcoeff=abs(shadowcoordbigDR.z-floor(shadowcoordbig_y*TEXTURESIZE)/TEXTURESIZE)*TEXTURESIZE;
                        */
                        //float dcoeff=1.0f-ucoeff;
                        float ul,dl,ur,dr;
                        if ( depthUL  <  sc2)
                        {
                            ul=SHADOW;
                        }
                        else
                        {
                            ul=1.0f;
                        }
                        if ( depthDL  <  sc2)
                        {
                            dl=SHADOW;
                        }
                        else
                        {
                            dl=1.0f;
                        }
                        if ( depthUR  <  sc2)
                        {
                            ur=SHADOW;
                        }
                        else
                        {
                            ur=1.0f;
                        }
                        if ( depthDR  <  sc2)
                        {
                            dr=SHADOW;
                        }
                        else
                        {
                            dr=1.0f;
                        }
                        //if ( depth  <  sc2) {visibility4+=SHADOW;} else {visibility4+=1.0f;}

                        float fx=fract(shadowcoordbig.x*TEXTURESIZE);
                        float fy=fract(shadowcoordbig_y*TEXTURESIZE);
                        //visibility4/=2.0f;
                        float a=mix(dl,ul,fy);
                        float b=mix(dr,ur,fy);
                        visibility4=mix(a,b,fx);
                    }
//---------------------------------------------------------------
                    else
                    {
                        //if ( depth  <  (ShadowCoord2.z/200.0f) ){
                        if ( depth  <  (ShadowCoord2.z/200.0f-biasx) )
                        {
                            //if ( texture2D( shadowMap, shadowcoordbig ).z  <  (ShadowCoord2.z/200.0f-biasx) ){
                            //if ( texture2D( shadowMap, shadowcoordbig ).z  <  (testz-biasx) ){
                            visibility4 = SHADOW;
                        }
                        else
                        {
                            visibility4 = 1.0f;
                        }
                    }
                    //visibility+=visibility4;
                    if (visibility4==SHADOW){
#ifdef ATTENUATION
                        visibility+=clamp(attenuation*10.0f,0.0f,1.0f);
#else
                        visibility+=1.0f-visibility4;
#endif
                    }
                    else
                        visibility+=0.0f;
                }
            visibility/=(smoothsize*smoothsize);
            visibility=1.0f-visibility;
            /*
            float attenuation=-depth+(ShadowCoord2.z/200.0f-biasx);
            visibility=attenuation;
            visibility=1.0f-(1.0f-visibility)*attenuation; //dim far shadows
            */
        }

        if (!inshadow)
        {
            vec2 pCoos=vec2(ShadowCoord2.xy/ShadowCoord2.w);
            pCoos.y=pCoos.y/2.0f;
            pCoos.y=clamp(pCoos.y,0.01f,0.49f);
            pCoos.x=clamp(pCoos.x,0.01f,0.99f);
            projectorColor=texture2D(lightMap, pCoos);
        }

        /*
        if (ShadowCoord2.x/ShadowCoord2.w<0.0f) {visibility=0.5; projectorColor=vec4(0.0f,0.0f,0.0f,0.0f);}
        if (ShadowCoord2.x/ShadowCoord2.w>=1.0f) {visibility=0.5; projectorColor=vec4(0.0f,0.0f,0.0f,0.0f);}
        if (ShadowCoord2.y/ShadowCoord2.w<0.0f) {visibility=0.5; projectorColor=vec4(0.0f,0.0f,0.0f,0.0f);}
        if (ShadowCoord2.y/ShadowCoord2.w>=1.0f) {visibility=0.5; projectorColor=vec4(0.0f,0.0f,0.0f,0.0f);}
        */

        totalprojectorColor+=projectorColor;

// 30/180 1/6
//this line was a quick hack to prevent projector wrapping-around, check if it needs correction
        /*
            r1*=ShadowAngle2;
            g1*=ShadowAngle2;
            b1*=ShadowAngle2;//0.5f;
        */
        //v1 = vec4((vec4(r1,g1,b1,1.0f)*visibility).rgb,1.0f);
        //v1= (vec4(1.0f,1.0f,1.ddddddddddddddddddddddddddddddddddddaaaaddddddwwwwwwwssssssssssssssssssssaa0f,1.0f)-((vec4(1.0f,1.0f,1.0f,1.0f)-v1)/1.5f))/1.5f;

//v1 = vec4((vec4(1.0f,1.0f,1.0f,1.0f)*visibility).rgb,1.0f);

        //gl_FragColor = vec4((( vAmbient*base + accvDiffuse*base + accvSpecular) * v1).rgb,1.0f);
        //gl_FragColor = vec4((base * v1).rgb,1.0f)+ accvSpecular;

        //gl_FragColor = vec4((base * v1).rgb,1.0f)+ vec4((accvDiffuse*v1).rgb,1.0f)+vec4(( accvSpecular*v1).rgb,1.0f);

        //if(visibility>0.5f)
        //totalvisibility*=visibility;


        totalvisibility+=visibility;

        //if (visibility==1.0f)
        //if (visibility==1.0f)
        //totalprojectorColor+=projectorColor;
        /*
            if (false)
            {
                if (ShadowAngle2<-0.5) totalprojectorColor=vec4(1.0f,0.0f,0.0f,1.0f);
                if (ShadowAngle2<0.0&&ShadowAngle2>-0.5f) totalprojectorColor=vec4(0.0f,1.0f,0.0f,1.0f);
                if (ShadowAngle2>0.0) totalprojectorColor=vec4(0.0f,0.0f,1.0f,1.0f);
                if (ShadowAngle2>0.5) totalprojectorColor=vec4(1.0f,1.0f,1.0f,1.0f);
            }
        */
    }
    totalvisibility/=NUMLIGHTS;
    totalprojectorColor=totalprojectorColor*totalvisibility;
//totalvisibility=pow(totalvisibility,2.1f);


    //r1=g1=b1=1.0f;
    totalvisibility=clamp(totalvisibility,0.0f,1.0f);
    v1 = vec4(totalvisibility,totalvisibility,totalvisibility,1.0f);
    v1 = (vec4(1.0f,1.0f,1.0f,1.0f)-((vec4(1.0f,1.0f,1.0f,1.0f)-v1)/1.2f))/1.2f;
    /*
        if (totalvisibility==1.0f)
            gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular)*v1*glColor+projectorColor;
        else
            gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular)*v1*glColor;
    */
//debugging:
    /*
    {
            //float ShadowAngle2=ShadowAngle[0];
            //float ShadowAngle2 = dot(normalize(vN_.xyz),normalize(vec3(vpos.xyz-LightsPos[0].xzy)));
            float ShadowAngle2 = dot(normalize(Lights[0].xyz),normalize(vec3(vpos.xyz-LightsPos[0].xyz)));
            if (ShadowAngle2<0.0)
                totalprojectorColor=vec4(0,-ShadowAngle2,0,1);
            else
                totalprojectorColor=vec4(ShadowAngle2,0,0,1);
    }
    */
    gl_FragColor = ( vAmbient*base + accvDiffuse*base + accvSpecular)*v1*glColor+totalprojectorColor;

    //gl_FragColor = totalprojectorColor;

    //gl_FragColor = vec4(ShadowAngle2,ShadowAngle2,ShadowAngle2,1.0f);
    //gl_FragColor = texture2D( shadowMap, (ShadowCoord2.xy/ShadowCoord2.w) );
    //gl_FragColor = vec4(vec3(ShadowCoord2.z/200.0f),1.0f);
}
